﻿/*
Photoshop JavaScript demo version 1.2 by Jon Ippolito.
Based on Custom Chromatic Aberration script v11.0 by Amy Pierce.
More technical advice at http://www.umit.maine.edu/~jon_ippolito/

This script makes a preset number of copies of a Photoshop layer
and gives these new layers random positions, opacities, and sizes.
 
To run this script, open a PhotoShop file with a background layer
and another layer named "bokeh". (Bokehs are lens artifacts
that sometimes appear scattered across a photographic image--but you 
can use any image you want as long as it doesn't take up the entire screen.)
*/

// Set Adobe Photoshop to use pixels and display no dialogs.
app.preferences.rulerUnits = Units.PIXELS
app.displayDialogs = DialogModes.NO
// Get the document dimensions.
var documentWidthAsInteger = app.activeDocument.width.value ; 
var documentHeightAsInteger = app.activeDocument.height.value ;
// Identify the bokeh layer (the one to be copied) and its position.
var bokehLayer = activeDocument.layers.getByName( "bokeh" ) ;
var bokehLeftAsInteger = parseInt(  bokehLayer.bounds[ 0 ]  ) ;
var bokehTopAsInteger =  parseInt(  bokehLayer.bounds[ 1 ]  ) ;
// Loop through as many copies as you want to make.
for( cloneCounter = 0 ; cloneCounter < 30 ; cloneCounter++ ) {
	var newLayer = bokehLayer.duplicate( ) ;
	// Calculate random movements of the layer, making sure not to go outside document window.
	var newLeftAsInteger = parseInt(  Math.random( ) * documentWidthAsInteger  ) ;
	var newTopAsInteger = parseInt(  ( Math.random( ) * documentHeightAsInteger )  ) ;
	// The shift in position will be the difference between its future and current positions.
	var shiftLeftAsPixels = ( newLeftAsInteger - bokehLeftAsInteger ) + "px" ;
	var shiftTopAsPixels = ( newTopAsInteger - bokehTopAsInteger ) + "px" ;
	// Move the new layer!
	newLayer.translate( shiftLeftAsPixels , shiftTopAsPixels ) ;
	// Give it a random opacity.
	var newOpacityAsPercent = parseInt( Math.random( )*100 ) ;
	newLayer.fillOpacity = newOpacityAsPercent ;
	// Give it a random size.
	var newSizeAsPercent = parseInt( Math.random( )*100 ) ;
	newLayer.resize( newSizeAsPercent , newSizeAsPercent ) ;
} ;
// Flatten the document for use as a JPEG (say).
app.activeDocument.flatten( ) ;

/* More on using JavaScript in Photoshop:
* Adobe Photoshop Developer Center  ( Adobe.com )
* Adobe Photoshop Scripting Forum  ( Adobe.com )
* Adobe Studio Exchange – Photoshop Scripts  ( Adobe.com )
* Working With Photoshop Scripts  ( PhotoshopSupport.com )
* Photoshop Scripting using JavaScript  ( Tranberry.com )
* Free Scripts for Photoshop  ( Morris-Photographics.com )
* Photoshop Scripting Community Forum  ( PS-Scripts )
*/